figure1 = figure('Color',[1 1 1],'rend','painters','units','centimeters','pos',[1 1 17 15]);

%%
subplot1 = subplot(2,2,1);        % add first plot in 2 x 2 grid
hold on

%load Data
MyData = esrf1100ph8;
yData = cell2mat(MyData(3:end,2:end));
xData =  cell2mat(MyData(3:end,1));
[a,b] = size(yData);
z = 0;
y2Data(1:a,1) = 0;

%smooth data 
for i = 1:b
    xData(1:a,i) = xData(1:a,1);
    z(1:a,i) = i;
    y2Data(1:end,i) = smooth(yData(1:end,i));
end

%surface map
double xq;
double yq;
double vq;
[xq,yq] = meshgrid(min(real(log10(xData))):.1:max(real(log10(xData))),1:1:a);
P = real(log10(xData));
Q = real(log10(y2Data));
vq = griddata(P,z,Q,xq,yq,'natural');

% Create figure
%figure1 = figure('Color',[1 1 1],'rend','painters','pos',[10 10 500 500]);

% Create axes
%%axes1 = axes('Parent',figure1);
hold(subplot1,'on');
set(gca,'color','none')

% Create surf
surfc(xq,yq,vq,'Parent',subplot1,'EdgeAlpha',0.45);

% Create light
light('Parent',subplot1,'Position',[47.94 8.23999999999998 -2],'Style','infinite');

% Create xlabel
xlabel('Q _{log10} (^{-1})');

% Create ylabel
ylabel('Time (minutes)');

% Create zlabel
zlabel({'','I _{log10} (mm^{-1})',''});

% xyz limits 
zlim(subplot1,[min(min(vq)) max(max(vq))+0.1]);
ylim(subplot1,[0 b]);

xmin = real(log10(min(xData)));
xmax = real(log10(max(xData)));
subplot1.XLim(1) = xmin(1,1);
subplot1.XLim(2) = xmax(1,1);

% axes settings 
view(subplot1,[48 8.24]);
box(subplot1,'on');
grid(subplot1,'on');
axis(subplot1,'square');

% Set the remaining axes properties
set(subplot1,'CLim',[-4 0],'Projection','perspective');
set(subplot1,'FontSize',8);
colormap jet
%%
subplot2 = subplot(2,2,[2 4]);       % add second plot in 2 x 2 grid
set(subplot2,'FontSize',8);
hold on

i = 1;

x1 = cell2mat(ttcf1100pH8(4:end,1));
x2 = cell2mat(ttcf1100pH8(3:683,19));

a = 1;
for n = [2 4 6 8 10 12 14 16 18];
h(n) = plot(x1,cell2mat(ttcf1100pH8(4:end,n))*10^a,'ok','MarkerSize',4);
a = a+.5;
end


a = 1;
for z = [20 22 24 26 28 30 32 34 36];
ha(z) = plot(x2,cell2mat(ttcf1100pH8(3:683,z))*10^a,'LineWidth',1.5);    
a = a+.5;
ha(z).Color = [0 0 1];
end

legend1 = legend([h(2) ha(20)],{'stage I fit','scattering'});
legend('boxoff');
set(legend1,'FontSize',8);

% Create xlabel
xlabel('Q (^{-1}) ');

% Create ylabel
ylabel('I(q) (scaled)');

% %% Uncomment the following line to preserve the X-limits of the axes
 xlim(subplot2,[0.005 0.6]);
% %% Uncomment the following line to preserve the Y-limits of the axes
 ylim(subplot2,[0.0001 100000]);
%  
% % Set the remaining axes properties
set(subplot2,'LineStyleOrderIndex',2,'XMinorTick','on','XScale','log',...
     'YMinorTick','on','YScale','log');


t=1;
for n = [20 22 24 26 28 30 32 34 36];
yend(t) = cell2mat(ttcf1100pH8(683,n));
t=t+1;
end

a = 1;
time ={'1 min','3','6','9','15','30','60','90','120'};
for na = [1:9];
fittext = text(x2(end,1)+0.08,yend(1,na)*10^a,time(na));
fittext.FontSize = 8;
a = a+.5;
end

% Create textarrow
annotation(figure1,'textarrow',[0.72 0.72],...
    [0.28 0.94],'String',{'time'},'FontSize',9);

%%
subplot3 = subplot(4,2,[5]);    
set(subplot3,'FontSize',8);

time1 = cell2mat(ttcf1100pH8calc(2:end,1));
chi1 = cell2mat(ttcf1100pH8calc(2:end,7));
radius_frac1 = cell2mat(ttcf1100pH8calc(2:end,15));
cutoff1 = cell2mat(ttcf1100pH8calc(2:end,13));
df1 = cell2mat(ttcf1100pH8calc(2:end,18));
rp1 = cell2mat(ttcf1100pH8calc(2:end,12));
re1 = cell2mat(ttcf1100pH8calc(2:end,14));

hold on
sc1 = plot(time1,rp1);
sc2 = plot(time1,re1,'o');
sc3 = plot(time1,radius_frac1,'o');


ylabel(subplot3,'Radius ()','FontSize',8);
xlabel(subplot3,'Time (min)','FontSize',8);
xlim([0 120]);
ylim([0 200]);

l1 = legend([sc1 sc2 sc3],{'polar','equat','rfrac'});
set(l1,'Box','off','FontSize',8,'Location','best','Orientation','horizontal');
l1.Position(2) = l1.Position(2)+.051;
%--------------------------------------------------------------------------------------------------------------------------------
subplot4 = subplot(4,4,13);    
set(subplot4,'FontSize',8);

hold on
sc5 = plot(time1,chi1,'^');
sc6 = plot(time1,df1,'s');

ylim([0 1.5]);
xlim([0 120]);
xlabel(subplot4,'Time (min)','FontSize',8);
ylabel('arbitrary','FontSize',8);

l2= legend([sc5 sc6],{'chi^2','df'});
set(l2,'Box','off','FontSize',8,'Location','northoutside','Orientation','horizontal');
l2.Position(2) = l2.Position(2)-.035;
l2.Position(1) = l2.Position(1)-.05;

set(subplot4,'YScale','lin','YTick',[0 0.5 1 1.5 2 2.5 3 3.5 4],'FontSize',8);
%------------------------------------------------------
subplot5 = subplot(4,4,14);    


 sc4 = plot(time1,cutoff1,'s');
 
ylim([0 500]);
xlim([0 120]);
xlabel(subplot5,'Time (min)','FontSize',8);
ylabel('cut-off ()','FontSize',8);
set(subplot5,'FontSize',8,'YAxisLocation','right','Box','off');

%format plots
set([sc1 sc2 sc3 sc4 sc5 sc6],'MarkerSize',5);
sc1.Marker = 'o';
sc1.LineStyle = 'none';
sc6.Marker = 'h';
sc1.MarkerFaceColor = [0 0 1];
sc1.MarkerEdgeColor = [0 0 0];
    sc2.MarkerFaceColor = [0 1 0];
    sc2.MarkerEdgeColor = [0.1 0.1 0.1];
sc3.MarkerFaceColor = [1 0 0];
sc3.MarkerEdgeColor = [0.1 0.1 0.1];
    sc4.MarkerFaceColor = [0.9294    0.6902    0.1294];
    sc4.MarkerEdgeColor = [0 0 0];
sc5.MarkerEdgeColor = [0.4941    0.1843    0.5569];
sc5.MarkerFaceColor = [1 1 1];
    sc6.MarkerFaceColor = [1 1 1];
    sc6.MarkerEdgeColor = [0.3020    0.7490    0.9294];
    sc6.LineStyle = 'none';

%%
subplot1.Position = [0.095 0.6 0.4 0.4];
subplot2.Position =[0.6 0.095 0.35 0.875];
subplot3.Position = [0.095 0.275 0.375 0.18];
subplot4.Position = [0.095 0.095 0.16 0.10];
subplot5.Position = [0.3 0.095 0.16 0.10];
%-------------------------------------------------------------------------
% Create textbox
annotation(figure1,'textbox',...
    [0.05 0.965 0.05 0.05],...
    'String','A',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.525 0.965 0.1 0.05],...
    'String','B',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.05 0.475 0.05 0.05],...
    'String','C',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');
%-------------------------------------------------------------------------


set(figure1,'PaperPositionMode','auto');
set(figure1,'PaperSize',[figure1.PaperPosition(3) figure1.PaperPosition(4)]);